function [detjac,dcdx,dcdy,dedx,dedy,h]=mygeotrasf2D(nov,vertices,noe,elements)
%GEOTRASF2D linear twodimensional transformation
%   [DETJAC,DCDX,DCDY,DEDX,DEDY]=MYGEOTRASF2D(NOV,VERTICES,NOE,ELEMENTS) computes
%   the elements of the Jacobian [DCDX DCDY; DEDX DEDY] of the twodimensional 
%   linear transformation from the triangles defined in ELEMENTS to the reference 
%   triangle.
%   DETJAC return for each element the determinants of the linear trasformation 
%   between the reference element to the triangles defined in ELEMENTS (it is 
%   the double of area of each triangle in ELEMENTS).
%
%   [DETJAC,DCDX,DCDY,DEDX,DEDY,H]=GEOTRASF2D(NOV,VERTICES,NOE,ELEMENTS) computes
%   in H the diameters of each triangle in ELEMENTS.
%
%   the difference between geotrasf2D and mygeotrasf2D is that the former
%   returns abs(detjac) while the latter returns detjac (negative for not valid
%   triangles)

%      

% Corner point indices
a1 = elements(1,:); a2 = elements(2,:); a3 = elements(3,:);

% Triangle sides 
s13x = vertices(1,a1)-vertices(1,a3);
s31y = vertices(2,a3)-vertices(2,a1);
s32x = vertices(1,a3)-vertices(1,a2);
s23y = vertices(2,a2)-vertices(2,a3);
s21x = vertices(1,a2)-vertices(1,a1);
s21y = vertices(2,a2)-vertices(2,a1);

% Determinant of the Jacobian matrix with sign (two times the area with sign of T)
detjac = s13x.*s23y-s31y.*s32x; 
if nargout == 5
  uno_su_detjac = 1./detjac;
% Jacobian elements
  dcdx = s31y.*uno_su_detjac;
  dcdy = s13x.*uno_su_detjac;
  dedx = -s21y.*uno_su_detjac;
  dedy = s21x.*uno_su_detjac;
end

if nargout == 6
  uno_su_detjac = 1./detjac;

% Jacobian elements
  dcdx = s31y.*uno_su_detjac;
  dcdy = s13x.*uno_su_detjac;
  dedx = -s21y.*uno_su_detjac;
  dedy = s21x.*uno_su_detjac;
  h = max([s13x.^2+s31y.^2;s32x.^2+s23y.^2;s21x.^2+s21y.^2]);
  h = sqrt(h);
end

% Determinant of the Jacobian of the linear transformation
% detjac = abs(detjac);

return